\typeout{Document Style `ICBEM 2018'}

\RequirePackage{txfonts}
\usepackage{txfonts}
\RequirePackage{cite}
\usepackage{cite}
\RequirePackage{mathptmx}
\usepackage{mathptmx}% Times
\RequirePackage[scaled=1]{helvet}
\usepackage[scaled=1]{helvet}% Helvetica 

\def\@ptsize{10}

%% change sizes and margins
\setlength{\paperwidth}{210.0mm}
\setlength{\paperheight}{297.0mm}
\setlength{\topmargin}{26mm}
    
\setlength{\hoffset}{-1in}
\setlength{\voffset}{-1in}

\setlength{\oddsidemargin}{20.0mm}
\setlength{\evensidemargin}{20.0mm}

\setlength{\textheight}{240mm}
\setlength{\textwidth}{170.0mm}
\setlength{\columnsep}{5.0mm}

\setlength{\parindent}{0cm}
\setlength{\parskip}{0pt}
\setlength{\headheight}{0pt}

\renewcommand{\normalsize}{\fontsize{10pt}{10pt}\selectfont}
\renewcommand{\baselinestretch}{1.2}

\newcommand{\tiny}{\fontsize{5pt}{5pt}\selectfont}
\newcommand{\scriptsize}{\fontsize{6pt}{6pt}\selectfont}
\newcommand{\footnotesize}{\fontsize{7pt}{7pt}\selectfont}
%\newcommand{\small}{\fontsize{8pt}{8pt}\selectfont}
\newcommand{\small}{\fontsize{9pt}{9pt}\selectfont}
\newcommand{\large}{\fontsize{11pt}{11pt}\selectfont}
\newcommand{\Large}{\fontsize{12pt}{12pt}\selectfont}
\newcommand{\LARGE}{\fontsize{14pt}{14pt}\selectfont}
\newcommand{\huge}{\fontsize{16pt}{16pt}\selectfont}
\newcommand{\Huge}{\fontsize{28pt}{28pt}\selectfont}

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\relax}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\relax}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\DeclareRobustCommand*\em{%
  \@nomath\em
  \ifdim\fontdimen\@ne\font>\z@
    \upshape
  \else
    \slshape
  \fi}


%% itemize
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}

%% enumarate
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}

%% lists
\setlength{\topsep}{0mm}
\setlength{\leftmargin}{10mm} 
\setlength{\labelsep}{3mm} 
\setlength{\itemsep}{0mm} 
\setlength{\parsep}{0mm} 
\setlength{\partopsep}{3pt}

%% tables
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{2\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}

\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable:}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}

\newcommand\tablename{Tab.}

\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{{\bfseries #1} #2}%
  \ifdim \wd\@tempboxa >\hsize
    {\bfseries #1} #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

%% figures
\newcounter{figure}
\renewcommand \thefigure {\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure:}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}

%%footnotes
\setcounter{footnote}{0}
\newcommand\@makefntext[1]{%
    \parindent 0em%
    \noindent%
    \hb@xt@0.5em{\hss\@makefnmark}#1}
	
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}

%% bibliographic
\newcommand\refname{References}
\newdimen\bibindent
\setlength\bibindent{1.5em}
\newenvironment{thebibliography}[1]
     {\section{\refname
        \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \small
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty


%%sectioning
\setcounter{secnumdepth}{2}
\newcounter{section}
\newcounter{subsection}[section]

\pagenumbering{arabic} 
\def\thesection{\arabic{section}}
\def\thesubsection{\thesection.\arabic{subsection}} 
%\def\thesubsubsection{\thesubsection.\arabic{subsubsection}} 
%\def\theparagraph{\thesubsubsection.\arabic{paragraph}} 
\setcounter{secnumdepth}{-2}


\long\def\section{\@startsection{section}{0}{0pt}{2.0ex plus .5ex minus .2ex}%
{1.0ex plus .2ex}{\normalfont\Large\sffamily\bfseries}}
\def\subsection{\@startsection{subsection}{1}{0pt}{2.0ex plus .5ex minus .2ex}%
{1.0ex plus .2ex}{\normalfont\sffamily \itshape}}

\newsavebox{\authorbox}
\long\def\author#1{\savebox{\authorbox}[\textwidth]{%
\parbox{\textwidth}{#1}}}

\newcommand\maketitle{\par
  \begingroup%
    \twocolumn[\@maketitle]%
  \endgroup%
}


\def\@maketitle{%
  {\LARGE  \sffamily \bfseries \@title \par}
  \vskip6pt
  {\usebox{\authorbox} \par}%
  \vskip24pt
}

\endinput %!PN
